﻿-- ■==============================================================================================■*/
--[[ !
    @file		ghost_highway_route_KOSHU.lua
    @brief		全国街道チャレンジ ルート情報(甲州街道)
    @author		AutoGenerated (otsuka-y)
    @date		2019/10/11 16:12:49
--]]
-- ■==============================================================================================■*/
-- ルートファイルのID
ROUTE_ID = "KOSHU"
-- ルート名
ROUTE_NAME = "甲州街道"

-- 門番・ボス分身を撃破することで入手可能な報酬
---- 記法
--   アイテムID, 報酬ID,
---- 報酬ID
--   どのマスの分身を倒した時にどの報酬を受け取るかを紐付ける(201-299)
RewardTable = {
	[CAT_STAMP] = {
		144,202,
		145,203,
		133,204,
	},
	[CAT_HONOR] = {
		630011,202,
		630012,203,
		630000,204,
	},

}

-- マス情報
---- 記法
-- マス種別, 関所とショートカット先ID, 報酬ID
----マス種別
--   SHOP,          //! 店舗マス
--   START,         //! スタートマス
--   MANUFARACTUER, //! メーカーマス
--   RECENT,        //! 最近プレイした相手マス
--   UNKNOWN,       //! ハテナマス
--   BONUS,         //! ボーナスマス
--   STATION,       //! 関所分身マス
--   BOSS,          //! ボス分身マス
--   BLANK,         //! 空白マス
---- 関所とショートカット先ID
-- 関所とショートカット先に対して同じIDを使用する (101-199)
---- 報酬ID
-- どのマスの分身を倒した時にどの報酬を受け取るかを紐付ける (201-299)
SquareTable = {
	START,
	RECENT,
	SHOP,
	RECENT,
	SHOP,
	MANUFARACTUER,
	SHOP,
	RECENT,
	BONUS,
	RECENT,
	MANUFARACTUER,
	RECENT,
	SHOP,
	RECENT,
	STATION,	101,	202,
	RECENT,
	MANUFARACTUER,
	RECENT,
	SHOP,	101,
	RECENT,
	UNKNOWN,
	SHOP,
	STATION,	102,	203,
	RECENT,
	SHOP,
	RECENT,
	RECENT,	102,
	MANUFARACTUER,
	RECENT,
	BONUS,
	SHOP,
	RECENT,
	BOSS,	204,

}

-- 関所・ボス分身の情報テーブル
---- 記法
-- 車ID, 走行エリアID
---- 走行エリアID
--  Ａ１０１―３．分身・乱入・イベントモードのコースデータ→area IDに
-- 指定されている数値を指定 (0-17)
BarrierEmenyTable = {
	2012,
	2013,
	2001,8,

}

-- 双六マスインデント情報のテーブル(手動指定専用)
-- -- 記法
-- (通常ライン)          最初マスのインデント, 終了マスのインデント,
-- (ショートカットライン)最初マスのインデント, 終了マスのインデント,
-- 通常ライン
-- ショートカットライン
-- 通常ライン… これらをライン数分指定する
-- いずれのラインのインデントも設定しない場合はテーブル内は空欄でも可だが、
-- 1ラインでも指定する場合は、インデントしないラインは全て0で埋めること
LineIndentTable = {
	70,70,
	70,70,
	0,130,
	290,180,
	90,130,
	200,170,

}

-- 関所名リストテーブル
-- -- 記法
-- 関所名,
-- flashの関所名表示にのみ使用する
StationNameTable = {
	"Tsuruse",
	"Kobotoke",

}

function GetRewardTable ( category_id )
    return unpack( RewardTable[category_id] )
end

function GetSquareTable( )
    return unpack( SquareTable )
end

function GetBarrierEnemyTable( )
    return unpack( BarrierEmenyTable )
end

function GetRouteName()
    return ROUTE_NAME
end

function GetLineIndentTable()
    return unpack( LineIndentTable )
end

function LineIndentTableSize()
    return #LineIndentTable
end

function GetStationNameTable()
    return unpack( StationNameTable )
end

function GetStationNameTableSize()
    return #StationNameTable
end
